
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{                                                       }
{ Copyright (c) 2004 Borland Software Corporation       }
{                                                       }
{*******************************************************}

unit FileHistoryAPI;

interface

uses Windows, CommCtrl, SysUtils, Classes, Menus, ActiveX, ToolsAPI;

type
  {$MINENUMSIZE 4}
  TOTAHistoryStyle = (hsBuffer, hsFile, hsLocalFile, hsRemoteRevision, hsActiveRevision);
  {$MINENUMSIZE 1}
  TOTAFileNameArray = array of WideString;
  IOTAFileHistoryProvider = interface;
  IOTAFileHistory = interface;
  IOTAFileHistoryNotifier = interface;

  IOTAFileHistoryManager = interface
    ['{55A2BEE4-A64C-4749-8388-070CAEFDEFA5}']
    function AddNotifier(const ANotifier: IOTAFileHistoryNotifier): Integer;
    procedure AddTemporaryLabel(const ALabelName: WideString; const AFiles: TOTAFileNameArray);
    function Get_Count: Integer;
    function GetFileHistoryProvider(Index: Integer): IOTAFileHistoryProvider;
    function RegisterHistoryProvider(const HistoryProvider: IOTAFileHistoryProvider): Integer;
    procedure RemoveNotifier(Index: Integer);
    procedure RevertTemporaryLabel(const ALabelName: WideString);
    procedure UnregisterHistoryProvider(Index: Integer);
    procedure UpdateProviders;

    property Count: Integer read Get_Count;
    property FileHistoryProvider[Index: Integer]: IOTAFileHistoryProvider read GetFileHistoryProvider;
  end;

  IOTAFileHistoryNotifier = interface(IOTANotifier)
    ['{286AC9E5-875A-4402-AF70-8ACDD6757EC8}']
    procedure ProvidersUpdated;
  end;

  IOTAFileHistoryProvider = interface(IDispatch)
    ['{B8CDB02D-93D8-4088-AE03-A28052AD0FAD}']
    function Get_Ident: WideString; safecall;
    function Get_Name: WideString; safecall;
    function GetFileHistory(const AFileName: WideString): IOTAFileHistory; safecall;

    property Ident: WideString read Get_Ident;
    property Name: WideString read Get_Name;
  end;

  IOTAFileHistory = interface(IDispatch)
    ['{92E624D2-A7CD-4C89-9B4E-71170955E96C}']
    function Get_Count: Integer; safecall;
    function GetAuthor(Index: Integer): WideString; safecall;
    function GetComment(Index: Integer): WideString; safecall;
    function GetContent(Index: Integer): IStream; safecall;
    function GetDate(Index: Integer): TDateTime; safecall;
    function GetIdent(Index: Integer): WideString; safecall;
    function GetHistoryStyle(Index: Integer): TOTAHistoryStyle; safecall;
    function GetLabelCount(Index: Integer): Integer; safecall;
    function GetLabels(Index, LabelIndex: Integer): WideString; safecall;

    property Author[Index: Integer]: WideString read GetAuthor;
    property Count: Integer read Get_Count;
    property Comment[Index: Integer]: WideString read GetComment;
    property Content[Index: Integer]: IStream read GetContent;
    property Date[Index: Integer]: TDateTime read GetDate;
    property HistoryStyle[Index: Integer]: TOTAHistoryStyle read GetHistoryStyle;
    property Ident[Index: Integer]: WideString read GetIdent;
    property LabelCount[Index: Integer]: Integer read GetLabelCount;
    property Labels[Index, LabelIndex: Integer]: WideString read GetLabels;
  end;

implementation

end.
